%------------------------------------------------------------------------------
% File     : DAT253^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Infinite streams (sequences/lists) 551
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : stream__551.p [Bla16]

% Status   : Theorem
% Rating   : 0.00 v7.2.0, 0.25 v7.1.0
% Syntax   : Number of formulae    :  356 ( 110 unt;  65 typ;   0 def)
%            Number of atoms       :  567 ( 313 equ;   0 cnn)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives : 3264 (  22   ~;   5   |;  15   &;3028   @)
%                                         (   0 <=>; 194  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  119 ( 119   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   63 (  62 usr;   5 con; 0-4 aty)
%            Number of variables   :  813 (  38   ^; 714   !;   9   ?; 813   :)
%                                         (  52  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:43:07.811
%------------------------------------------------------------------------------
%----Could-be-implicit typings (6)
thf(ty_t_Stream__Mirabelle__hbrgyiwlrc_Ostream,type,
    stream170649215stream: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Num_Onum,type,
    num: $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (59)
thf(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Onumeral,type,
    numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Osemiring__numeral,type,
    semiring_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Obounded__lattice__top,type,
    bounded_lattice_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Num_Oinc,type,
    inc: num > num ).

thf(sy_c_Num_Oneg__numeral__class_Odbl,type,
    neg_numeral_dbl: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Num_Onum_OBit0,type,
    bit0: num > num ).

thf(sy_c_Num_Onum_OOne,type,
    one2: num ).

thf(sy_c_Num_Onumeral__class_Onumeral,type,
    numeral_numeral: 
      !>[A: $tType] : ( num > A ) ).

thf(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > ( set @ B ) ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Osinterleave,type,
    stream865922174rleave: 
      !>[A: $tType] : ( ( stream170649215stream @ A ) > ( stream170649215stream @ A ) > ( stream170649215stream @ A ) ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Osmember,type,
    stream1586597341member: 
      !>[A: $tType] : ( A > ( stream170649215stream @ A ) > $o ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Osmerge,type,
    stream857257621smerge: 
      !>[A: $tType] : ( ( stream170649215stream @ ( stream170649215stream @ A ) ) > ( stream170649215stream @ A ) ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Osnth,type,
    stream370371455e_snth: 
      !>[A: $tType] : ( ( stream170649215stream @ A ) > nat > A ) ).

thf(sy_c_Stream__Mirabelle__hbrgyiwlrc_Ostream_Osset,type,
    stream30925839e_sset: 
      !>[A: $tType] : ( ( stream170649215stream @ A ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_n____,type,
    n: nat ).

thf(sy_v_s1,type,
    s1: stream170649215stream @ a ).

thf(sy_v_s2,type,
    s2: stream170649215stream @ a ).

thf(sy_v_x____,type,
    x: a ).

%----Relevant facts (251)
thf(fact_0__092_060open_062x_A_061_As1_A_B_B_An_092_060close_062,axiom,
    ( x
    = ( stream370371455e_snth @ a @ s1 @ n ) ) ).

% \<open>x = s1 !! n\<close>
thf(fact_1__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062n_O_Ax_A_061_As1_A_B_B_An_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [N: nat] :
        ( x
       != ( stream370371455e_snth @ a @ s1 @ N ) ) ).

% \<open>\<And>thesis. (\<And>n. x = s1 !! n \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_2__092_060open_062sinterleave_As1_As2_A_B_B_A_I2_A_K_An_J_A_061_Ax_092_060close_062,axiom,
    ( ( stream370371455e_snth @ a @ ( stream865922174rleave @ a @ s1 @ s2 ) @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) @ n ) )
    = x ) ).

% \<open>sinterleave s1 s2 !! (2 * n) = x\<close>
thf(fact_3__092_060open_062x_A_092_060in_062_Asset_As1_092_060close_062,axiom,
    member @ a @ x @ ( stream30925839e_sset @ a @ s1 ) ).

% \<open>x \<in> sset s1\<close>
thf(fact_4__092_060open_062x_A_092_060in_062_Asset_As1_A_092_060union_062_Asset_As2_092_060close_062,axiom,
    member @ a @ x @ ( sup_sup @ ( set @ a ) @ ( stream30925839e_sset @ a @ s1 ) @ ( stream30925839e_sset @ a @ s2 ) ) ).

% \<open>x \<in> sset s1 \<union> sset s2\<close>
thf(fact_5_UNIV__I,axiom,
    ! [A: $tType,X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_I
thf(fact_6_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ).

% iso_tuple_UNIV_I
thf(fact_7_top__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( top @ C @ ( type2 @ C ) )
     => ( ( top_top @ ( D > C ) )
        = ( ^ [X2: D] : ( top_top @ C ) ) ) ) ).

% top_apply
thf(fact_8_image__eqI,axiom,
    ! [A: $tType,B: $tType,B2: A,F: B > A,X: B,A2: set @ B] :
      ( ( B2
        = ( F @ X ) )
     => ( ( member @ B @ X @ A2 )
       => ( member @ A @ B2 @ ( image @ B @ A @ F @ A2 ) ) ) ) ).

% image_eqI
thf(fact_9_surjD,axiom,
    ! [A: $tType,B: $tType,F: B > A,Y: A] :
      ( ( ( image @ B @ A @ F @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ? [X3: B] :
          ( Y
          = ( F @ X3 ) ) ) ).

% surjD
thf(fact_10_surjE,axiom,
    ! [A: $tType,B: $tType,F: B > A,Y: A] :
      ( ( ( image @ B @ A @ F @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ~ ! [X3: B] :
            ( Y
           != ( F @ X3 ) ) ) ).

% surjE
thf(fact_11_surjI,axiom,
    ! [B: $tType,A: $tType,G: B > A,F: A > B] :
      ( ! [X3: A] :
          ( ( G @ ( F @ X3 ) )
          = X3 )
     => ( ( image @ B @ A @ G @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% surjI
thf(fact_12_rangeI,axiom,
    ! [A: $tType,B: $tType,F: B > A,X: B] : ( member @ A @ ( F @ X ) @ ( image @ B @ A @ F @ ( top_top @ ( set @ B ) ) ) ) ).

% rangeI
thf(fact_13_surj__def,axiom,
    ! [B: $tType,A: $tType,F: B > A] :
      ( ( ( image @ B @ A @ F @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
      = ( ! [Y2: A] :
          ? [X2: B] :
            ( Y2
            = ( F @ X2 ) ) ) ) ).

% surj_def
thf(fact_14_range__eqI,axiom,
    ! [A: $tType,B: $tType,B2: A,F: B > A,X: B] :
      ( ( B2
        = ( F @ X ) )
     => ( member @ A @ B2 @ ( image @ B @ A @ F @ ( top_top @ ( set @ B ) ) ) ) ) ).

% range_eqI
thf(fact_15_sset__range,axiom,
    ! [A: $tType] :
      ( ( stream30925839e_sset @ A )
      = ( ^ [S: stream170649215stream @ A] : ( image @ nat @ A @ ( stream370371455e_snth @ A @ S ) @ ( top_top @ ( set @ nat ) ) ) ) ) ).

% sset_range
thf(fact_16_UnCI,axiom,
    ! [A: $tType,C2: A,B3: set @ A,A2: set @ A] :
      ( ( ~ ( member @ A @ C2 @ B3 )
       => ( member @ A @ C2 @ A2 ) )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) ) ) ).

% UnCI
thf(fact_17_Un__iff,axiom,
    ! [A: $tType,C2: A,A2: set @ A,B3: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) )
      = ( ( member @ A @ C2 @ A2 )
        | ( member @ A @ C2 @ B3 ) ) ) ).

% Un_iff
thf(fact_18_UnE,axiom,
    ! [A: $tType,C2: A,A2: set @ A,B3: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) )
     => ( ~ ( member @ A @ C2 @ A2 )
       => ( member @ A @ C2 @ B3 ) ) ) ).

% UnE
thf(fact_19_UnI1,axiom,
    ! [A: $tType,C2: A,A2: set @ A,B3: set @ A] :
      ( ( member @ A @ C2 @ A2 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) ) ) ).

% UnI1
thf(fact_20_UnI2,axiom,
    ! [A: $tType,C2: A,B3: set @ A,A2: set @ A] :
      ( ( member @ A @ C2 @ B3 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) ) ) ).

% UnI2
thf(fact_21_bex__Un,axiom,
    ! [A: $tType,A2: set @ A,B3: set @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member @ A @ X2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) )
            & ( P @ X2 ) ) )
      = ( ? [X2: A] :
            ( ( member @ A @ X2 @ A2 )
            & ( P @ X2 ) )
        | ? [X2: A] :
            ( ( member @ A @ X2 @ B3 )
            & ( P @ X2 ) ) ) ) ).

% bex_Un
thf(fact_22_ball__Un,axiom,
    ! [A: $tType,A2: set @ A,B3: set @ A,P: A > $o] :
      ( ( ! [X2: A] :
            ( ( member @ A @ X2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) )
           => ( P @ X2 ) ) )
      = ( ! [X2: A] :
            ( ( member @ A @ X2 @ A2 )
           => ( P @ X2 ) )
        & ! [X2: A] :
            ( ( member @ A @ X2 @ B3 )
           => ( P @ X2 ) ) ) ) ).

% ball_Un
thf(fact_23_Un__assoc,axiom,
    ! [A: $tType,A2: set @ A,B3: set @ A,C3: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) @ C3 )
      = ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B3 @ C3 ) ) ) ).

% Un_assoc
thf(fact_24_Un__absorb,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ A2 )
      = A2 ) ).

% Un_absorb
thf(fact_25_Un__commute,axiom,
    ! [A: $tType] :
      ( ( sup_sup @ ( set @ A ) )
      = ( ^ [A3: set @ A,B4: set @ A] : ( sup_sup @ ( set @ A ) @ B4 @ A3 ) ) ) ).

% Un_commute
thf(fact_26_Un__left__absorb,axiom,
    ! [A: $tType,A2: set @ A,B3: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ A2 @ B3 ) )
      = ( sup_sup @ ( set @ A ) @ A2 @ B3 ) ) ).

% Un_left_absorb
thf(fact_27_Un__left__commute,axiom,
    ! [A: $tType,A2: set @ A,B3: set @ A,C3: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B3 @ C3 ) )
      = ( sup_sup @ ( set @ A ) @ B3 @ ( sup_sup @ ( set @ A ) @ A2 @ C3 ) ) ) ).

% Un_left_commute
thf(fact_28_image__Un,axiom,
    ! [A: $tType,B: $tType,F: B > A,A2: set @ B,B3: set @ B] :
      ( ( image @ B @ A @ F @ ( sup_sup @ ( set @ B ) @ A2 @ B3 ) )
      = ( sup_sup @ ( set @ A ) @ ( image @ B @ A @ F @ A2 ) @ ( image @ B @ A @ F @ B3 ) ) ) ).

% image_Un
thf(fact_29_top__set__def,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( collect @ A @ ( top_top @ ( A > $o ) ) ) ) ).

% top_set_def
thf(fact_30_Un__UNIV__right,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( top_top @ ( set @ A ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% Un_UNIV_right
thf(fact_31_Un__UNIV__left,axiom,
    ! [A: $tType,B3: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( top_top @ ( set @ A ) ) @ B3 )
      = ( top_top @ ( set @ A ) ) ) ).

% Un_UNIV_left
thf(fact_32_snth__sset,axiom,
    ! [A: $tType,S2: stream170649215stream @ A,N2: nat] : ( member @ A @ ( stream370371455e_snth @ A @ S2 @ N2 ) @ ( stream30925839e_sset @ A @ S2 ) ) ).

% snth_sset
thf(fact_33_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,X: A,A2: set @ A,B2: B,F: A > B] :
      ( ( member @ A @ X @ A2 )
     => ( ( B2
          = ( F @ X ) )
       => ( member @ B @ B2 @ ( image @ A @ B @ F @ A2 ) ) ) ) ).

% rev_image_eqI
thf(fact_34_ball__imageD,axiom,
    ! [A: $tType,B: $tType,F: B > A,A2: set @ B,P: A > $o] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ ( image @ B @ A @ F @ A2 ) )
         => ( P @ X3 ) )
     => ! [X4: B] :
          ( ( member @ B @ X4 @ A2 )
         => ( P @ ( F @ X4 ) ) ) ) ).

% ball_imageD
thf(fact_35_image__cong,axiom,
    ! [B: $tType,A: $tType,M: set @ A,N3: set @ A,F: A > B,G: A > B] :
      ( ( M = N3 )
     => ( ! [X3: A] :
            ( ( member @ A @ X3 @ N3 )
           => ( ( F @ X3 )
              = ( G @ X3 ) ) )
       => ( ( image @ A @ B @ F @ M )
          = ( image @ A @ B @ G @ N3 ) ) ) ) ).

% image_cong
thf(fact_36_bex__imageD,axiom,
    ! [A: $tType,B: $tType,F: B > A,A2: set @ B,P: A > $o] :
      ( ? [X4: A] :
          ( ( member @ A @ X4 @ ( image @ B @ A @ F @ A2 ) )
          & ( P @ X4 ) )
     => ? [X3: B] :
          ( ( member @ B @ X3 @ A2 )
          & ( P @ ( F @ X3 ) ) ) ) ).

% bex_imageD
thf(fact_37_image__iff,axiom,
    ! [A: $tType,B: $tType,Z: A,F: B > A,A2: set @ B] :
      ( ( member @ A @ Z @ ( image @ B @ A @ F @ A2 ) )
      = ( ? [X2: B] :
            ( ( member @ B @ X2 @ A2 )
            & ( Z
              = ( F @ X2 ) ) ) ) ) ).

% image_iff
thf(fact_38_imageI,axiom,
    ! [B: $tType,A: $tType,X: A,A2: set @ A,F: A > B] :
      ( ( member @ A @ X @ A2 )
     => ( member @ B @ ( F @ X ) @ ( image @ A @ B @ F @ A2 ) ) ) ).

% imageI
thf(fact_39_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X3: A] : ( member @ A @ X3 @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_witness
thf(fact_40_UNIV__eq__I,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ! [X3: A] : ( member @ A @ X3 @ A2 )
     => ( ( top_top @ ( set @ A ) )
        = A2 ) ) ).

% UNIV_eq_I
thf(fact_41_sup__top__right,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_top @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ ( top_top @ A ) )
          = ( top_top @ A ) ) ) ).

% sup_top_right
thf(fact_42_sup__top__left,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_top @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ ( top_top @ A ) @ X )
          = ( top_top @ A ) ) ) ).

% sup_top_left
thf(fact_43_semiring__norm_I169_J,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Z: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ V ) @ ( times_times @ A @ ( numeral_numeral @ A @ W ) @ Z ) )
          = ( times_times @ A @ ( numeral_numeral @ A @ ( times_times @ num @ V @ W ) ) @ Z ) ) ) ).

% semiring_norm(169)
thf(fact_44_numeral__times__numeral,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ M2 ) @ ( numeral_numeral @ A @ N2 ) )
          = ( numeral_numeral @ A @ ( times_times @ num @ M2 @ N2 ) ) ) ) ).

% numeral_times_numeral
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A4: A,P: A > $o] :
      ( ( member @ A @ A4 @ ( collect @ A @ P ) )
      = ( P @ A4 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_semiring__norm_I85_J,axiom,
    ! [M2: num] :
      ( ( bit0 @ M2 )
     != one2 ) ).

% semiring_norm(85)
thf(fact_50_semiring__norm_I83_J,axiom,
    ! [N2: num] :
      ( one2
     != ( bit0 @ N2 ) ) ).

% semiring_norm(83)
thf(fact_51_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ one2 ) @ A4 )
          = A4 ) ) ).

% mult_numeral_1
thf(fact_52_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ A4 @ ( numeral_numeral @ A @ one2 ) )
          = A4 ) ) ).

% mult_numeral_1_right
thf(fact_53_sup__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B @ ( type2 @ B ) )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B,X2: A] : ( sup_sup @ B @ ( F2 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% sup_apply
thf(fact_54_sup_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( sup_sup @ A @ A4 @ A4 )
          = A4 ) ) ).

% sup.idem
thf(fact_55_semiring__norm_I87_J,axiom,
    ! [M2: num,N2: num] :
      ( ( ( bit0 @ M2 )
        = ( bit0 @ N2 ) )
      = ( M2 = N2 ) ) ).

% semiring_norm(87)
thf(fact_56_num_Oinject_I1_J,axiom,
    ! [X22: num,Y22: num] :
      ( ( ( bit0 @ X22 )
        = ( bit0 @ Y22 ) )
      = ( X22 = Y22 ) ) ).

% num.inject(1)
thf(fact_57_numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( ( numeral_numeral @ A @ M2 )
            = ( numeral_numeral @ A @ N2 ) )
          = ( M2 = N2 ) ) ) ).

% numeral_eq_iff
thf(fact_58_sup_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A4 @ B2 ) @ B2 )
          = ( sup_sup @ A @ A4 @ B2 ) ) ) ).

% sup.right_idem
thf(fact_59_sup__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ X @ Y ) )
          = ( sup_sup @ A @ X @ Y ) ) ) ).

% sup_left_idem
thf(fact_60_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( sup_sup @ A @ A4 @ ( sup_sup @ A @ A4 @ B2 ) )
          = ( sup_sup @ A @ A4 @ B2 ) ) ) ).

% sup.left_idem
thf(fact_61_sup__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ X )
          = X ) ) ).

% sup_idem
thf(fact_62_top1I,axiom,
    ! [A: $tType,X: A] : ( top_top @ ( A > $o ) @ X ) ).

% top1I
thf(fact_63_semiring__norm_I13_J,axiom,
    ! [M2: num,N2: num] :
      ( ( times_times @ num @ ( bit0 @ M2 ) @ ( bit0 @ N2 ) )
      = ( bit0 @ ( bit0 @ ( times_times @ num @ M2 @ N2 ) ) ) ) ).

% semiring_norm(13)
thf(fact_64_semiring__norm_I11_J,axiom,
    ! [M2: num] :
      ( ( times_times @ num @ M2 @ one2 )
      = M2 ) ).

% semiring_norm(11)
thf(fact_65_semiring__norm_I12_J,axiom,
    ! [N2: num] :
      ( ( times_times @ num @ one2 @ N2 )
      = N2 ) ).

% semiring_norm(12)
thf(fact_66_sup__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ Y @ ( sup_sup @ A @ X @ Z ) ) ) ) ).

% sup_left_commute
thf(fact_67_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( sup_sup @ A @ B2 @ ( sup_sup @ A @ A4 @ C2 ) )
          = ( sup_sup @ A @ A4 @ ( sup_sup @ A @ B2 @ C2 ) ) ) ) ).

% sup.left_commute
thf(fact_68_sup__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [X2: A,Y2: A] : ( sup_sup @ A @ Y2 @ X2 ) ) ) ) ).

% sup_commute
thf(fact_69_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [A5: A,B5: A] : ( sup_sup @ A @ B5 @ A5 ) ) ) ) ).

% sup.commute
thf(fact_70_sup__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ Y ) @ Z )
          = ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) ) ) ) ).

% sup_assoc
thf(fact_71_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A4 @ B2 ) @ C2 )
          = ( sup_sup @ A @ A4 @ ( sup_sup @ A @ B2 @ C2 ) ) ) ) ).

% sup.assoc
thf(fact_72_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B @ ( type2 @ B ) )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B,X2: A] : ( sup_sup @ B @ ( F2 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% sup_fun_def
thf(fact_73_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [X2: A,Y2: A] : ( sup_sup @ A @ Y2 @ X2 ) ) ) ) ).

% inf_sup_aci(5)
thf(fact_74_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ Y ) @ Z )
          = ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(6)
thf(fact_75_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ Y @ ( sup_sup @ A @ X @ Z ) ) ) ) ).

% inf_sup_aci(7)
thf(fact_76_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ X @ Y ) )
          = ( sup_sup @ A @ X @ Y ) ) ) ).

% inf_sup_aci(8)
thf(fact_77_num_Odistinct_I1_J,axiom,
    ! [X22: num] :
      ( one2
     != ( bit0 @ X22 ) ) ).

% num.distinct(1)
thf(fact_78_top__empty__eq,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( A > $o ) )
      = ( ^ [X2: A] : ( member @ A @ X2 @ ( top_top @ ( set @ A ) ) ) ) ) ).

% top_empty_eq
thf(fact_79_snth__sset__smerge,axiom,
    ! [A: $tType,Ss: stream170649215stream @ ( stream170649215stream @ A ),N2: nat,M2: nat] : ( member @ A @ ( stream370371455e_snth @ A @ ( stream370371455e_snth @ ( stream170649215stream @ A ) @ Ss @ N2 ) @ M2 ) @ ( stream30925839e_sset @ A @ ( stream857257621smerge @ A @ Ss ) ) ) ).

% snth_sset_smerge
thf(fact_80_dbl__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K: num] :
          ( ( neg_numeral_dbl @ A @ ( numeral_numeral @ A @ K ) )
          = ( numeral_numeral @ A @ ( bit0 @ K ) ) ) ) ).

% dbl_simps(5)
thf(fact_81_top__conj_I2_J,axiom,
    ! [A: $tType,P: $o,X: A] :
      ( ( P
        & ( top_top @ ( A > $o ) @ X ) )
      = P ) ).

% top_conj(2)
thf(fact_82_top__conj_I1_J,axiom,
    ! [A: $tType,X: A,P: $o] :
      ( ( ( top_top @ ( A > $o ) @ X )
        & P )
      = P ) ).

% top_conj(1)
thf(fact_83_Stream__Mirabelle__hbrgyiwlrc_Osmember__def,axiom,
    ! [A: $tType] :
      ( ( stream1586597341member @ A )
      = ( ^ [X2: A,S: stream170649215stream @ A] : ( member @ A @ X2 @ ( stream30925839e_sset @ A @ S ) ) ) ) ).

% Stream_Mirabelle_hbrgyiwlrc.smember_def
thf(fact_84_mult__2__right,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ Z @ ( numeral_numeral @ A @ ( bit0 @ one2 ) ) )
          = ( plus_plus @ A @ Z @ Z ) ) ) ).

% mult_2_right
thf(fact_85_mult__2,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ ( bit0 @ one2 ) ) @ Z )
          = ( plus_plus @ A @ Z @ Z ) ) ) ).

% mult_2
thf(fact_86_semiring__norm_I6_J,axiom,
    ! [M2: num,N2: num] :
      ( ( plus_plus @ num @ ( bit0 @ M2 ) @ ( bit0 @ N2 ) )
      = ( bit0 @ ( plus_plus @ num @ M2 @ N2 ) ) ) ).

% semiring_norm(6)
thf(fact_87_semiring__norm_I2_J,axiom,
    ( ( plus_plus @ num @ one2 @ one2 )
    = ( bit0 @ one2 ) ) ).

% semiring_norm(2)
thf(fact_88_add__numeral__left,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Z: A] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ V ) @ ( plus_plus @ A @ ( numeral_numeral @ A @ W ) @ Z ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ V @ W ) ) @ Z ) ) ) ).

% add_numeral_left
thf(fact_89_numeral__plus__numeral,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ M2 ) @ ( numeral_numeral @ A @ N2 ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ M2 @ N2 ) ) ) ) ).

% numeral_plus_numeral
thf(fact_90_dbl__def,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl @ A )
        = ( ^ [X2: A] : ( plus_plus @ A @ X2 @ X2 ) ) ) ) ).

% dbl_def
thf(fact_91_is__num__normalize_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% is_num_normalize(1)
thf(fact_92_add__One__commute,axiom,
    ! [N2: num] :
      ( ( plus_plus @ num @ one2 @ N2 )
      = ( plus_plus @ num @ N2 @ one2 ) ) ).

% add_One_commute
thf(fact_93_left__add__mult__distrib,axiom,
    ! [I: nat,U: nat,J: nat,K: nat] :
      ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U ) @ K ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ ( plus_plus @ nat @ I @ J ) @ U ) @ K ) ) ).

% left_add_mult_distrib
thf(fact_94_numeral__Bit0,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( numeral_numeral @ A @ ( bit0 @ N2 ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ N2 ) @ ( numeral_numeral @ A @ N2 ) ) ) ) ).

% numeral_Bit0
thf(fact_95_distrib__left__numeral,axiom,
    ! [A: $tType] :
      ( ( ( numeral @ A @ ( type2 @ A ) )
        & ( semiring @ A @ ( type2 @ A ) ) )
     => ! [V: num,B2: A,C2: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ V ) @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ ( numeral_numeral @ A @ V ) @ B2 ) @ ( times_times @ A @ ( numeral_numeral @ A @ V ) @ C2 ) ) ) ) ).

% distrib_left_numeral
thf(fact_96_distrib__right__numeral,axiom,
    ! [A: $tType] :
      ( ( ( numeral @ A @ ( type2 @ A ) )
        & ( semiring @ A @ ( type2 @ A ) ) )
     => ! [A4: A,B2: A,V: num] :
          ( ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ ( numeral_numeral @ A @ V ) )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ ( numeral_numeral @ A @ V ) ) @ ( times_times @ A @ B2 @ ( numeral_numeral @ A @ V ) ) ) ) ) ).

% distrib_right_numeral
thf(fact_97_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A4 @ B2 )
            = ( plus_plus @ A @ A4 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add_left_cancel
thf(fact_98_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A4 )
            = ( plus_plus @ A @ C2 @ A4 ) )
          = ( B2 = C2 ) ) ) ).

% add_right_cancel
thf(fact_99_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A,D2: A] :
          ( ( ( A4 != B2 )
            & ( C2 != D2 ) )
          = ( ( plus_plus @ A @ ( times_times @ A @ A4 @ C2 ) @ ( times_times @ A @ B2 @ D2 ) )
           != ( plus_plus @ A @ ( times_times @ A @ A4 @ D2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ) ).

% crossproduct_noteq
thf(fact_100_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [W: A,Y: A,X: A,Z: A] :
          ( ( ( plus_plus @ A @ ( times_times @ A @ W @ Y ) @ ( times_times @ A @ X @ Z ) )
            = ( plus_plus @ A @ ( times_times @ A @ W @ Z ) @ ( times_times @ A @ X @ Y ) ) )
          = ( ( W = X )
            | ( Y = Z ) ) ) ) ).

% crossproduct_eq
thf(fact_101_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A4 )
            = ( plus_plus @ A @ C2 @ A4 ) )
         => ( B2 = C2 ) ) ) ).

% add_right_imp_eq
thf(fact_102_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A4 @ B2 )
            = ( plus_plus @ A @ A4 @ C2 ) )
         => ( B2 = C2 ) ) ) ).

% add_left_imp_eq
thf(fact_103_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( plus_plus @ A @ B2 @ ( plus_plus @ A @ A4 @ C2 ) )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.left_commute
thf(fact_104_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A5: A,B5: A] : ( plus_plus @ A @ B5 @ A5 ) ) ) ) ).

% add.commute
thf(fact_105_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A4 )
            = ( plus_plus @ A @ C2 @ A4 ) )
          = ( B2 = C2 ) ) ) ).

% add.right_cancel
thf(fact_106_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A4 @ B2 )
            = ( plus_plus @ A @ A4 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add.left_cancel
thf(fact_107_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.assoc
thf(fact_108_semiring__normalization__rules_I20_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A,D2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ ( plus_plus @ A @ C2 @ D2 ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A4 @ C2 ) @ ( plus_plus @ A @ B2 @ D2 ) ) ) ) ).

% semiring_normalization_rules(20)
thf(fact_109_semiring__normalization__rules_I21_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% semiring_normalization_rules(21)
thf(fact_110_semiring__normalization__rules_I22_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,C2: A,D2: A] :
          ( ( plus_plus @ A @ A4 @ ( plus_plus @ A @ C2 @ D2 ) )
          = ( plus_plus @ A @ C2 @ ( plus_plus @ A @ A4 @ D2 ) ) ) ) ).

% semiring_normalization_rules(22)
thf(fact_111_semiring__normalization__rules_I23_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( plus_plus @ A @ A4 @ C2 ) @ B2 ) ) ) ).

% semiring_normalization_rules(23)
thf(fact_112_semiring__normalization__rules_I24_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A5: A,C4: A] : ( plus_plus @ A @ C4 @ A5 ) ) ) ) ).

% semiring_normalization_rules(24)
thf(fact_113_semiring__normalization__rules_I25_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,C2: A,D2: A] :
          ( ( plus_plus @ A @ A4 @ ( plus_plus @ A @ C2 @ D2 ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A4 @ C2 ) @ D2 ) ) ) ).

% semiring_normalization_rules(25)
thf(fact_114_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( K = L ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_115_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_116_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( times_times @ A @ B2 @ ( times_times @ A @ A4 @ C2 ) )
          = ( times_times @ A @ A4 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% mult.left_commute
thf(fact_117_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A5: A,B5: A] : ( times_times @ A @ B5 @ A5 ) ) ) ) ).

% mult.commute
thf(fact_118_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A4 @ B2 ) @ C2 )
          = ( times_times @ A @ A4 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% mult.assoc
thf(fact_119_semiring__normalization__rules_I7_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A5: A,B5: A] : ( times_times @ A @ B5 @ A5 ) ) ) ) ).

% semiring_normalization_rules(7)
thf(fact_120_semiring__normalization__rules_I13_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ ( times_times @ A @ Ly @ Ry ) ) ) ) ).

% semiring_normalization_rules(13)
thf(fact_121_semiring__normalization__rules_I14_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ ( times_times @ A @ Rx @ Ry ) ) ) ) ) ).

% semiring_normalization_rules(14)
thf(fact_122_semiring__normalization__rules_I15_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Ry ) ) ) ) ).

% semiring_normalization_rules(15)
thf(fact_123_semiring__normalization__rules_I16_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ly ) ) ) ).

% semiring_normalization_rules(16)
thf(fact_124_semiring__normalization__rules_I17_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ Rx ) ) ) ) ).

% semiring_normalization_rules(17)
thf(fact_125_semiring__normalization__rules_I18_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ry ) ) ) ).

% semiring_normalization_rules(18)
thf(fact_126_semiring__normalization__rules_I19_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ Lx @ Ry ) ) ) ) ).

% semiring_normalization_rules(19)
thf(fact_127_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A4 @ B2 ) @ C2 )
          = ( times_times @ A @ A4 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_128_semiring__normalization__rules_I34_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( times_times @ A @ X @ ( plus_plus @ A @ Y @ Z ) )
          = ( plus_plus @ A @ ( times_times @ A @ X @ Y ) @ ( times_times @ A @ X @ Z ) ) ) ) ).

% semiring_normalization_rules(34)
thf(fact_129_semiring__normalization__rules_I8_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% semiring_normalization_rules(8)
thf(fact_130_semiring__normalization__rules_I1_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,M2: A,B2: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A4 @ M2 ) @ ( times_times @ A @ B2 @ M2 ) )
          = ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ M2 ) ) ) ).

% semiring_normalization_rules(1)
thf(fact_131_add__mult__distrib,axiom,
    ! [M2: nat,N2: nat,K: nat] :
      ( ( times_times @ nat @ ( plus_plus @ nat @ M2 @ N2 ) @ K )
      = ( plus_plus @ nat @ ( times_times @ nat @ M2 @ K ) @ ( times_times @ nat @ N2 @ K ) ) ) ).

% add_mult_distrib
thf(fact_132_add__mult__distrib2,axiom,
    ! [K: nat,M2: nat,N2: nat] :
      ( ( times_times @ nat @ K @ ( plus_plus @ nat @ M2 @ N2 ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ K @ M2 ) @ ( times_times @ nat @ K @ N2 ) ) ) ).

% add_mult_distrib2
thf(fact_133_ring__class_Oring__distribs_I2_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% ring_class.ring_distribs(2)
thf(fact_134_ring__class_Oring__distribs_I1_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ B2 ) @ ( times_times @ A @ A4 @ C2 ) ) ) ) ).

% ring_class.ring_distribs(1)
thf(fact_135_linordered__field__class_Osign__simps_I36_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ B2 ) @ ( times_times @ A @ A4 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(36)
thf(fact_136_linordered__field__class_Osign__simps_I28_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( plus_plus @ A @ B2 @ ( plus_plus @ A @ A4 @ C2 ) )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(28)
thf(fact_137_linordered__field__class_Osign__simps_I27_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A5: A,B5: A] : ( plus_plus @ A @ B5 @ A5 ) ) ) ) ).

% linordered_field_class.sign_simps(27)
thf(fact_138_linordered__field__class_Osign__simps_I26_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(26)
thf(fact_139_linordered__field__class_Osign__simps_I25_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [B2: A,A4: A,C2: A] :
          ( ( times_times @ A @ B2 @ ( times_times @ A @ A4 @ C2 ) )
          = ( times_times @ A @ A4 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(25)
thf(fact_140_linordered__field__class_Osign__simps_I24_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A5: A,B5: A] : ( times_times @ A @ B5 @ A5 ) ) ) ) ).

% linordered_field_class.sign_simps(24)
thf(fact_141_linordered__field__class_Osign__simps_I23_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A4 @ B2 ) @ C2 )
          = ( times_times @ A @ A4 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(23)
thf(fact_142_nat__add__right__cancel,axiom,
    ! [M2: nat,K: nat,N2: nat] :
      ( ( ( plus_plus @ nat @ M2 @ K )
        = ( plus_plus @ nat @ N2 @ K ) )
      = ( M2 = N2 ) ) ).

% nat_add_right_cancel
thf(fact_143_nat__add__left__cancel,axiom,
    ! [K: nat,M2: nat,N2: nat] :
      ( ( ( plus_plus @ nat @ K @ M2 )
        = ( plus_plus @ nat @ K @ N2 ) )
      = ( M2 = N2 ) ) ).

% nat_add_left_cancel
thf(fact_144_combine__common__factor,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A4: A,E: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A4 @ E ) @ ( plus_plus @ A @ ( times_times @ A @ B2 @ E ) @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ E ) @ C2 ) ) ) ).

% combine_common_factor
thf(fact_145_distrib__right,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% distrib_right
thf(fact_146_distrib__left,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ A4 @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ B2 ) @ ( times_times @ A @ A4 @ C2 ) ) ) ) ).

% distrib_left
thf(fact_147_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( ( comm_semiring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% comm_semiring_class.distrib
thf(fact_148_linordered__field__class_Osign__simps_I35_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A4 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A4 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(35)
thf(fact_149_dbl__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl @ A @ ( one_one @ A ) )
        = ( numeral_numeral @ A @ ( bit0 @ one2 ) ) ) ) ).

% dbl_simps(3)
thf(fact_150_numeral__plus__one,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ N2 ) @ ( one_one @ A ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ N2 @ one2 ) ) ) ) ).

% numeral_plus_one
thf(fact_151_one__plus__numeral,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N2 ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ one2 @ N2 ) ) ) ) ).

% one_plus_numeral
thf(fact_152_one__add__one,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A @ ( one_one @ A ) @ ( one_one @ A ) )
        = ( numeral_numeral @ A @ ( bit0 @ one2 ) ) ) ) ).

% one_add_one
thf(fact_153_nat__1__eq__mult__iff,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ( one_one @ nat )
        = ( times_times @ nat @ M2 @ N2 ) )
      = ( ( M2
          = ( one_one @ nat ) )
        & ( N2
          = ( one_one @ nat ) ) ) ) ).

% nat_1_eq_mult_iff
thf(fact_154_nat__mult__eq__1__iff,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ( times_times @ nat @ M2 @ N2 )
        = ( one_one @ nat ) )
      = ( ( M2
          = ( one_one @ nat ) )
        & ( N2
          = ( one_one @ nat ) ) ) ) ).

% nat_mult_eq_1_iff
thf(fact_155_mult_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ A4 @ ( one_one @ A ) )
          = A4 ) ) ).

% mult.right_neutral
thf(fact_156_mult_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A4 )
          = A4 ) ) ).

% mult.left_neutral
thf(fact_157_one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( ( one_one @ A )
            = ( numeral_numeral @ A @ N2 ) )
          = ( one2 = N2 ) ) ) ).

% one_eq_numeral_iff
thf(fact_158_numeral__eq__one__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( ( numeral_numeral @ A @ N2 )
            = ( one_one @ A ) )
          = ( N2 = one2 ) ) ) ).

% numeral_eq_one_iff
thf(fact_159_nat__mult__1__right,axiom,
    ! [N2: nat] :
      ( ( times_times @ nat @ N2 @ ( one_one @ nat ) )
      = N2 ) ).

% nat_mult_1_right
thf(fact_160_nat__mult__1,axiom,
    ! [N2: nat] :
      ( ( times_times @ nat @ ( one_one @ nat ) @ N2 )
      = N2 ) ).

% nat_mult_1
thf(fact_161_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ A4 @ ( one_one @ A ) )
          = A4 ) ) ).

% mult.comm_neutral
thf(fact_162_comm__monoid__mult__class_Omult__1,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A4 )
          = A4 ) ) ).

% comm_monoid_mult_class.mult_1
thf(fact_163_semiring__normalization__rules_I11_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A4 )
          = A4 ) ) ).

% semiring_normalization_rules(11)
thf(fact_164_semiring__normalization__rules_I12_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( times_times @ A @ A4 @ ( one_one @ A ) )
          = A4 ) ) ).

% semiring_normalization_rules(12)
thf(fact_165_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_166_one__plus__numeral__commute,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [X: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ X ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ X ) @ ( one_one @ A ) ) ) ) ).

% one_plus_numeral_commute
thf(fact_167_semiring__normalization__rules_I2_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A4: A,M2: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A4 @ M2 ) @ M2 )
          = ( times_times @ A @ ( plus_plus @ A @ A4 @ ( one_one @ A ) ) @ M2 ) ) ) ).

% semiring_normalization_rules(2)
thf(fact_168_semiring__normalization__rules_I3_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [M2: A,A4: A] :
          ( ( plus_plus @ A @ M2 @ ( times_times @ A @ A4 @ M2 ) )
          = ( times_times @ A @ ( plus_plus @ A @ A4 @ ( one_one @ A ) ) @ M2 ) ) ) ).

% semiring_normalization_rules(3)
thf(fact_169_semiring__normalization__rules_I4_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [M2: A] :
          ( ( plus_plus @ A @ M2 @ M2 )
          = ( times_times @ A @ ( plus_plus @ A @ ( one_one @ A ) @ ( one_one @ A ) ) @ M2 ) ) ) ).

% semiring_normalization_rules(4)
thf(fact_170_numeral__One,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ( ( numeral_numeral @ A @ one2 )
        = ( one_one @ A ) ) ) ).

% numeral_One
thf(fact_171_numerals_I1_J,axiom,
    ( ( numeral_numeral @ nat @ one2 )
    = ( one_one @ nat ) ) ).

% numerals(1)
thf(fact_172_nat__1__add__1,axiom,
    ( ( plus_plus @ nat @ ( one_one @ nat ) @ ( one_one @ nat ) )
    = ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) ) ).

% nat_1_add_1
thf(fact_173_dbl__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( bit0 @ one2 ) ) ) ) ) ).

% dbl_simps(4)
thf(fact_174_add__neg__numeral__special_I9_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( bit0 @ one2 ) ) ) ) ) ).

% add_neg_numeral_special(9)
thf(fact_175_add__2__eq__Suc_H,axiom,
    ! [N2: nat] :
      ( ( plus_plus @ nat @ N2 @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) )
      = ( suc @ ( suc @ N2 ) ) ) ).

% add_2_eq_Suc'
thf(fact_176_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A4 )
            = ( uminus_uminus @ A @ B2 ) )
          = ( A4 = B2 ) ) ) ).

% neg_equal_iff_equal
thf(fact_177_add_Oinverse__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ A4 ) )
          = A4 ) ) ).

% add.inverse_inverse
thf(fact_178_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ( uminus_uminus @ A @ X )
            = ( uminus_uminus @ A @ Y ) )
          = ( X = Y ) ) ) ).

% compl_eq_compl_iff
thf(fact_179_double__compl,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ X ) )
          = X ) ) ).

% double_compl
thf(fact_180_uminus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A3: A > B,X2: A] : ( uminus_uminus @ B @ ( A3 @ X2 ) ) ) ) ) ).

% uminus_apply
thf(fact_181_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_182_nat_Oinject,axiom,
    ! [X22: nat,Y22: nat] :
      ( ( ( suc @ X22 )
        = ( suc @ Y22 ) )
      = ( X22 = Y22 ) ) ).

% nat.inject
thf(fact_183_add__minus__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( plus_plus @ A @ A4 @ ( plus_plus @ A @ ( uminus_uminus @ A @ A4 ) @ B2 ) )
          = B2 ) ) ).

% add_minus_cancel
thf(fact_184_minus__add__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ A4 ) @ ( plus_plus @ A @ A4 @ B2 ) )
          = B2 ) ) ).

% minus_add_cancel
thf(fact_185_minus__add__distrib,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( uminus_uminus @ A @ ( plus_plus @ A @ A4 @ B2 ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ A4 ) @ ( uminus_uminus @ A @ B2 ) ) ) ) ).

% minus_add_distrib
thf(fact_186_neg__numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ M2 ) )
            = ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) )
          = ( M2 = N2 ) ) ) ).

% neg_numeral_eq_iff
thf(fact_187_mult__minus__left,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ A4 ) @ B2 )
          = ( uminus_uminus @ A @ ( times_times @ A @ A4 @ B2 ) ) ) ) ).

% mult_minus_left
thf(fact_188_minus__mult__minus,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ A4 ) @ ( uminus_uminus @ A @ B2 ) )
          = ( times_times @ A @ A4 @ B2 ) ) ) ).

% minus_mult_minus
thf(fact_189_mult__minus__right,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( times_times @ A @ A4 @ ( uminus_uminus @ A @ B2 ) )
          = ( uminus_uminus @ A @ ( times_times @ A @ A4 @ B2 ) ) ) ) ).

% mult_minus_right
thf(fact_190_add__Suc__right,axiom,
    ! [M2: nat,N2: nat] :
      ( ( plus_plus @ nat @ M2 @ ( suc @ N2 ) )
      = ( suc @ ( plus_plus @ nat @ M2 @ N2 ) ) ) ).

% add_Suc_right
thf(fact_191_add__neg__numeral__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M2 ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) )
          = ( uminus_uminus @ A @ ( plus_plus @ A @ ( numeral_numeral @ A @ M2 ) @ ( numeral_numeral @ A @ N2 ) ) ) ) ) ).

% add_neg_numeral_simps(3)
thf(fact_192_mult__minus1,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ Z )
          = ( uminus_uminus @ A @ Z ) ) ) ).

% mult_minus1
thf(fact_193_mult__minus1__right,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ Z @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( uminus_uminus @ A @ Z ) ) ) ).

% mult_minus1_right
thf(fact_194_compl__sup__top,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ ( uminus_uminus @ A @ X ) @ X )
          = ( top_top @ A ) ) ) ).

% compl_sup_top
thf(fact_195_sup__compl__top,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ ( uminus_uminus @ A @ X ) )
          = ( top_top @ A ) ) ) ).

% sup_compl_top
thf(fact_196_sup__compl__top__left1,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( sup_sup @ A @ ( uminus_uminus @ A @ X ) @ ( sup_sup @ A @ X @ Y ) )
          = ( top_top @ A ) ) ) ).

% sup_compl_top_left1
thf(fact_197_sup__compl__top__left2,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ ( uminus_uminus @ A @ X ) @ Y ) )
          = ( top_top @ A ) ) ) ).

% sup_compl_top_left2
thf(fact_198_mult__Suc__right,axiom,
    ! [M2: nat,N2: nat] :
      ( ( times_times @ nat @ M2 @ ( suc @ N2 ) )
      = ( plus_plus @ nat @ M2 @ ( times_times @ nat @ M2 @ N2 ) ) ) ).

% mult_Suc_right
thf(fact_199_dbl__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K: num] :
          ( ( neg_numeral_dbl @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ K ) ) )
          = ( uminus_uminus @ A @ ( neg_numeral_dbl @ A @ ( numeral_numeral @ A @ K ) ) ) ) ) ).

% dbl_simps(1)
thf(fact_200_numeral__eq__neg__one__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) )
            = ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( N2 = one2 ) ) ) ).

% numeral_eq_neg_one_iff
thf(fact_201_neg__one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( ( uminus_uminus @ A @ ( one_one @ A ) )
            = ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) )
          = ( N2 = one2 ) ) ) ).

% neg_one_eq_numeral_iff
thf(fact_202_semiring__norm_I168_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Y: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ V ) ) @ ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ W ) ) @ Y ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ V @ W ) ) ) @ Y ) ) ) ).

% semiring_norm(168)
thf(fact_203_Suc__numeral,axiom,
    ! [N2: num] :
      ( ( suc @ ( numeral_numeral @ nat @ N2 ) )
      = ( numeral_numeral @ nat @ ( plus_plus @ num @ N2 @ one2 ) ) ) ).

% Suc_numeral
thf(fact_204_semiring__norm_I172_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [V: num,W: num,Y: B] :
          ( ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ V ) ) @ ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ W ) ) @ Y ) )
          = ( times_times @ B @ ( numeral_numeral @ B @ ( times_times @ num @ V @ W ) ) @ Y ) ) ) ).

% semiring_norm(172)
thf(fact_205_semiring__norm_I171_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [V: num,W: num,Y: B] :
          ( ( times_times @ B @ ( numeral_numeral @ B @ V ) @ ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ W ) ) @ Y ) )
          = ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ ( times_times @ num @ V @ W ) ) ) @ Y ) ) ) ).

% semiring_norm(171)
thf(fact_206_semiring__norm_I170_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [V: num,W: num,Y: B] :
          ( ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ V ) ) @ ( times_times @ B @ ( numeral_numeral @ B @ W ) @ Y ) )
          = ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ ( times_times @ num @ V @ W ) ) ) @ Y ) ) ) ).

% semiring_norm(170)
thf(fact_207_mult__neg__numeral__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ M2 ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( times_times @ num @ M2 @ N2 ) ) ) ) ) ).

% mult_neg_numeral_simps(3)
thf(fact_208_mult__neg__numeral__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M2 ) ) @ ( numeral_numeral @ A @ N2 ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( times_times @ num @ M2 @ N2 ) ) ) ) ) ).

% mult_neg_numeral_simps(2)
thf(fact_209_mult__neg__numeral__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M2 ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) )
          = ( numeral_numeral @ A @ ( times_times @ num @ M2 @ N2 ) ) ) ) ).

% mult_neg_numeral_simps(1)
thf(fact_210_add__2__eq__Suc,axiom,
    ! [N2: nat] :
      ( ( plus_plus @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) @ N2 )
      = ( suc @ ( suc @ N2 ) ) ) ).

% add_2_eq_Suc
thf(fact_211_Suc__1,axiom,
    ( ( suc @ ( one_one @ nat ) )
    = ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) ) ).

% Suc_1
thf(fact_212_Suc__eq__plus1,axiom,
    ( suc
    = ( ^ [N4: nat] : ( plus_plus @ nat @ N4 @ ( one_one @ nat ) ) ) ) ).

% Suc_eq_plus1
thf(fact_213_Suc__eq__plus1__left,axiom,
    ( suc
    = ( plus_plus @ nat @ ( one_one @ nat ) ) ) ).

% Suc_eq_plus1_left
thf(fact_214_one__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ( ( one_one @ A )
       != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% one_neq_neg_one
thf(fact_215_add_Oinverse__distrib__swap,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( uminus_uminus @ A @ ( plus_plus @ A @ A4 @ B2 ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A4 ) ) ) ) ).

% add.inverse_distrib_swap
thf(fact_216_minus__equation__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A4 )
            = B2 )
          = ( ( uminus_uminus @ A @ B2 )
            = A4 ) ) ) ).

% minus_equation_iff
thf(fact_217_equation__minus__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( A4
            = ( uminus_uminus @ A @ B2 ) )
          = ( B2
            = ( uminus_uminus @ A @ A4 ) ) ) ) ).

% equation_minus_iff
thf(fact_218_numeral__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( numeral_numeral @ A @ M2 )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) ) ) ).

% numeral_neq_neg_numeral
thf(fact_219_neg__numeral__neq__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M2: num,N2: num] :
          ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ M2 ) )
         != ( numeral_numeral @ A @ N2 ) ) ) ).

% neg_numeral_neq_numeral
thf(fact_220_is__num__normalize_I8_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( uminus_uminus @ A @ ( plus_plus @ A @ A4 @ B2 ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A4 ) ) ) ) ).

% is_num_normalize(8)
thf(fact_221_fun__Compl__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A3: A > B,X2: A] : ( uminus_uminus @ B @ ( A3 @ X2 ) ) ) ) ) ).

% fun_Compl_def
thf(fact_222_n__not__Suc__n,axiom,
    ! [N2: nat] :
      ( N2
     != ( suc @ N2 ) ) ).

% n_not_Suc_n
thf(fact_223_Suc__inject,axiom,
    ! [X: nat,Y: nat] :
      ( ( ( suc @ X )
        = ( suc @ Y ) )
     => ( X = Y ) ) ).

% Suc_inject
thf(fact_224_Suc__mult__cancel1,axiom,
    ! [K: nat,M2: nat,N2: nat] :
      ( ( ( times_times @ nat @ ( suc @ K ) @ M2 )
        = ( times_times @ nat @ ( suc @ K ) @ N2 ) )
      = ( M2 = N2 ) ) ).

% Suc_mult_cancel1
thf(fact_225_square__eq__iff,axiom,
    ! [A: $tType] :
      ( ( idom @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( ( times_times @ A @ A4 @ A4 )
            = ( times_times @ A @ B2 @ B2 ) )
          = ( ( A4 = B2 )
            | ( A4
              = ( uminus_uminus @ A @ B2 ) ) ) ) ) ).

% square_eq_iff
thf(fact_226_minus__mult__commute,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A4: A,B2: A] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ A4 ) @ B2 )
          = ( times_times @ A @ A4 @ ( uminus_uminus @ A @ B2 ) ) ) ) ).

% minus_mult_commute
thf(fact_227_add__Suc,axiom,
    ! [M2: nat,N2: nat] :
      ( ( plus_plus @ nat @ ( suc @ M2 ) @ N2 )
      = ( suc @ ( plus_plus @ nat @ M2 @ N2 ) ) ) ).

% add_Suc
thf(fact_228_add__Suc__shift,axiom,
    ! [M2: nat,N2: nat] :
      ( ( plus_plus @ nat @ ( suc @ M2 ) @ N2 )
      = ( plus_plus @ nat @ M2 @ ( suc @ N2 ) ) ) ).

% add_Suc_shift
thf(fact_229_numeral__times__minus__swap,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A @ ( type2 @ A ) )
     => ! [W: num,X: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ W ) @ ( uminus_uminus @ A @ X ) )
          = ( times_times @ A @ X @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ W ) ) ) ) ) ).

% numeral_times_minus_swap
thf(fact_230_numeral__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( numeral_numeral @ A @ N2 )
         != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% numeral_neq_neg_one
thf(fact_231_one__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( one_one @ A )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) ) ) ).

% one_neq_neg_numeral
thf(fact_232_ring__normalization__rules_I1_J,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A )
        = ( times_times @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ) ).

% ring_normalization_rules(1)
thf(fact_233_square__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( ( times_times @ A @ X @ X )
            = ( one_one @ A ) )
          = ( ( X
              = ( one_one @ A ) )
            | ( X
              = ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ) ) ).

% square_eq_1_iff
thf(fact_234_sup__cancel__left1,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,A4: A,B2: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ A4 ) @ ( sup_sup @ A @ ( uminus_uminus @ A @ X ) @ B2 ) )
          = ( top_top @ A ) ) ) ).

% sup_cancel_left1
thf(fact_235_sup__cancel__left2,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,A4: A,B2: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ ( uminus_uminus @ A @ X ) @ A4 ) @ ( sup_sup @ A @ X @ B2 ) )
          = ( top_top @ A ) ) ) ).

% sup_cancel_left2
thf(fact_236_Compl__partition,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( uminus_uminus @ ( set @ A ) @ A2 ) )
      = ( top_top @ ( set @ A ) ) ) ).

% Compl_partition
thf(fact_237_Compl__partition2,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A2 ) @ A2 )
      = ( top_top @ ( set @ A ) ) ) ).

% Compl_partition2
thf(fact_238_mult__Suc,axiom,
    ! [M2: nat,N2: nat] :
      ( ( times_times @ nat @ ( suc @ M2 ) @ N2 )
      = ( plus_plus @ nat @ N2 @ ( times_times @ nat @ M2 @ N2 ) ) ) ).

% mult_Suc
thf(fact_239_mult__1s_I4_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [B2: B] :
          ( ( times_times @ B @ B2 @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ one2 ) ) )
          = ( uminus_uminus @ B @ B2 ) ) ) ).

% mult_1s(4)
thf(fact_240_mult__1s_I3_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [B2: B] :
          ( ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ one2 ) ) @ B2 )
          = ( uminus_uminus @ B @ B2 ) ) ) ).

% mult_1s(3)
thf(fact_241_uminus__numeral__One,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ one2 ) )
        = ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% uminus_numeral_One
thf(fact_242_Suc__nat__number__of__add,axiom,
    ! [V: num,N2: nat] :
      ( ( suc @ ( plus_plus @ nat @ ( numeral_numeral @ nat @ V ) @ N2 ) )
      = ( plus_plus @ nat @ ( numeral_numeral @ nat @ ( plus_plus @ num @ V @ one2 ) ) @ N2 ) ) ).

% Suc_nat_number_of_add
thf(fact_243_Suc__double__not__eq__double,axiom,
    ! [M2: nat,N2: nat] :
      ( ( suc @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) @ M2 ) )
     != ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) @ N2 ) ) ).

% Suc_double_not_eq_double
thf(fact_244_double__not__eq__Suc__double,axiom,
    ! [M2: nat,N2: nat] :
      ( ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) @ M2 )
     != ( suc @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) @ N2 ) ) ) ).

% double_not_eq_Suc_double
thf(fact_245_add__neg__numeral__special_I6_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M2: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M2 ) ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( inc @ M2 ) ) ) ) ) ).

% add_neg_numeral_special(6)
thf(fact_246_Compl__eq__Compl__iff,axiom,
    ! [A: $tType,A2: set @ A,B3: set @ A] :
      ( ( ( uminus_uminus @ ( set @ A ) @ A2 )
        = ( uminus_uminus @ ( set @ A ) @ B3 ) )
      = ( A2 = B3 ) ) ).

% Compl_eq_Compl_iff
thf(fact_247_Compl__iff,axiom,
    ! [A: $tType,C2: A,A2: set @ A] :
      ( ( member @ A @ C2 @ ( uminus_uminus @ ( set @ A ) @ A2 ) )
      = ( ~ ( member @ A @ C2 @ A2 ) ) ) ).

% Compl_iff
thf(fact_248_ComplI,axiom,
    ! [A: $tType,C2: A,A2: set @ A] :
      ( ~ ( member @ A @ C2 @ A2 )
     => ( member @ A @ C2 @ ( uminus_uminus @ ( set @ A ) @ A2 ) ) ) ).

% ComplI
thf(fact_249_add__neg__numeral__special_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [N2: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N2 ) ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( inc @ N2 ) ) ) ) ) ).

% add_neg_numeral_special(5)
thf(fact_250_double__complement,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( uminus_uminus @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A2 ) )
      = A2 ) ).

% double_complement

%----Type constructors (39)
thf(tcon_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice_1,axiom,
    ! [A6: $tType] : ( bounded_lattice @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice_2,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( bounded_lattice @ A7 @ ( type2 @ A7 ) )
     => ( bounded_lattice @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice__top,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( bounded_lattice @ A7 @ ( type2 @ A7 ) )
     => ( bounded_lattice_top @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Lattices_Osemilattice__sup,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( semilattice_sup @ A7 @ ( type2 @ A7 ) )
     => ( semilattice_sup @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( boolean_algebra @ A7 @ ( type2 @ A7 ) )
     => ( boolean_algebra @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( lattice @ A7 @ ( type2 @ A7 ) )
     => ( lattice @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Otop,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( top @ A7 @ ( type2 @ A7 ) )
     => ( top @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Groups_Ouminus,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( uminus @ A7 @ ( type2 @ A7 ) )
     => ( uminus @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Lattices_Osemilattice__sup_3,axiom,
    semilattice_sup @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Num_Osemiring__numeral,axiom,
    semiring_numeral @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Lattices_Olattice_4,axiom,
    lattice @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring,axiom,
    semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Num_Onumeral,axiom,
    numeral @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oone,axiom,
    one @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice__top_5,axiom,
    ! [A6: $tType] : ( bounded_lattice_top @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__sup_6,axiom,
    ! [A6: $tType] : ( semilattice_sup @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_7,axiom,
    ! [A6: $tType] : ( boolean_algebra @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Olattice_8,axiom,
    ! [A6: $tType] : ( lattice @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Otop_9,axiom,
    ! [A6: $tType] : ( top @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Groups_Ouminus_10,axiom,
    ! [A6: $tType] : ( uminus @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__lattice__top_11,axiom,
    bounded_lattice_top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__sup_12,axiom,
    semilattice_sup @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_13,axiom,
    boolean_algebra @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Olattice_14,axiom,
    lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Otop_15,axiom,
    top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ouminus_16,axiom,
    uminus @ $o @ ( type2 @ $o ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    member @ a @ x @ ( image @ nat @ a @ ( stream370371455e_snth @ a @ ( stream865922174rleave @ a @ s1 @ s2 ) ) @ ( top_top @ ( set @ nat ) ) ) ).

%------------------------------------------------------------------------------
